@echo off
:: https://privacy.sexy — v0.13.8 — Sat, 11 Oct 2025 16:24:24 GMT
:: Ensure PowerShell is available
where PowerShell >nul 2>&1 || (
    echo PowerShell is not available. Please install or enable PowerShell.
    pause & exit 1
)
:: Ensure admin privileges
fltmc >nul 2>&1 || (
    echo Administrator privileges are required.
    PowerShell Start -Verb RunAs '%0' 2> nul || (
        echo Right-click on the script and select "Run as administrator".
        pause & exit 1
    )
    exit 0
)
:: Initialize environment
setlocal EnableExtensions DisableDelayedExpansion


:: ----------------------------------------------------------
:: ----------Disable "Direct Play" feature (revert)----------
:: ----------------------------------------------------------
echo --- Disable "Direct Play" feature (revert)
:: Revert the 'DirectPlay' feature to its default settings
PowerShell -ExecutionPolicy Unrestricted -Command "$featureName = 'DirectPlay'; $ignoreMissingOnRevert =  $false; $disabledByDefault = $true <# $false #>; $feature = Get-WindowsOptionalFeature -FeatureName "^""$featureName"^"" -Online -ErrorAction Stop; if (-Not $feature) { if ($ignoreMissingOnRevert) { Write-Output "^""Skipping: The feature `"^""$featureName`"^"" is not found. No action required."^""; Exit 0; }; Write-Error "^""Failed to revert changes to the feature `"^""$featureName`"^"". The feature is not found."^""; Exit 1; }; if ($feature.State -eq [Microsoft.Dism.Commands.FeatureState]::Enabled) { Write-Output "^""Skipping: The feature `"^""$featureName`"^"" is already enabled. No action required."^""; Exit 0; }; if ($disabledByDefault) { Write-Output "^""Skipping: The feature `"^""$featureName`"^"" is already disabled and this is the default configuration."^""; Exit 0; }; try { Write-Host "^""Enabling feature: `"^""$featureName`"^""."^""; Enable-WindowsOptionalFeature -FeatureName "^""$featureName"^"" -Online -NoRestart -LogLevel ([Microsoft.Dism.Commands.LogLevel]::Errors) -WarningAction SilentlyContinue -ErrorAction Stop | Out-Null; } catch { Write-Error "^""Failed to enable feature `"^""$featureName`"^"": $($_.Exception.Message)"^""; Exit 1; }; Write-Output "^""Successfully enabled the feature `"^""$featureName`"^""."^""; Exit 0"
:: ----------------------------------------------------------


:: ----------------------------------------------------------
:: -------Disable "Internet Explorer" feature (revert)-------
:: ----------------------------------------------------------
echo --- Disable "Internet Explorer" feature (revert)
:: Revert the 'Internet-Explorer-Optional-x64' feature to its default settings
PowerShell -ExecutionPolicy Unrestricted -Command "$featureName = 'Internet-Explorer-Optional-x64'; $ignoreMissingOnRevert = $true <# $false #>; $disabledByDefault =  $false; $feature = Get-WindowsOptionalFeature -FeatureName "^""$featureName"^"" -Online -ErrorAction Stop; if (-Not $feature) { if ($ignoreMissingOnRevert) { Write-Output "^""Skipping: The feature `"^""$featureName`"^"" is not found. No action required."^""; Exit 0; }; Write-Error "^""Failed to revert changes to the feature `"^""$featureName`"^"". The feature is not found."^""; Exit 1; }; if ($feature.State -eq [Microsoft.Dism.Commands.FeatureState]::Enabled) { Write-Output "^""Skipping: The feature `"^""$featureName`"^"" is already enabled. No action required."^""; Exit 0; }; if ($disabledByDefault) { Write-Output "^""Skipping: The feature `"^""$featureName`"^"" is already disabled and this is the default configuration."^""; Exit 0; }; try { Write-Host "^""Enabling feature: `"^""$featureName`"^""."^""; Enable-WindowsOptionalFeature -FeatureName "^""$featureName"^"" -Online -NoRestart -LogLevel ([Microsoft.Dism.Commands.LogLevel]::Errors) -WarningAction SilentlyContinue -ErrorAction Stop | Out-Null; } catch { Write-Error "^""Failed to enable feature `"^""$featureName`"^"": $($_.Exception.Message)"^""; Exit 1; }; Write-Output "^""Successfully enabled the feature `"^""$featureName`"^""."^""; Exit 0"
:: Revert the 'Internet-Explorer-Optional-x84' feature to its default settings
PowerShell -ExecutionPolicy Unrestricted -Command "$featureName = 'Internet-Explorer-Optional-x84'; $ignoreMissingOnRevert = $true <# $false #>; $disabledByDefault =  $false; $feature = Get-WindowsOptionalFeature -FeatureName "^""$featureName"^"" -Online -ErrorAction Stop; if (-Not $feature) { if ($ignoreMissingOnRevert) { Write-Output "^""Skipping: The feature `"^""$featureName`"^"" is not found. No action required."^""; Exit 0; }; Write-Error "^""Failed to revert changes to the feature `"^""$featureName`"^"". The feature is not found."^""; Exit 1; }; if ($feature.State -eq [Microsoft.Dism.Commands.FeatureState]::Enabled) { Write-Output "^""Skipping: The feature `"^""$featureName`"^"" is already enabled. No action required."^""; Exit 0; }; if ($disabledByDefault) { Write-Output "^""Skipping: The feature `"^""$featureName`"^"" is already disabled and this is the default configuration."^""; Exit 0; }; try { Write-Host "^""Enabling feature: `"^""$featureName`"^""."^""; Enable-WindowsOptionalFeature -FeatureName "^""$featureName"^"" -Online -NoRestart -LogLevel ([Microsoft.Dism.Commands.LogLevel]::Errors) -WarningAction SilentlyContinue -ErrorAction Stop | Out-Null; } catch { Write-Error "^""Failed to enable feature `"^""$featureName`"^"": $($_.Exception.Message)"^""; Exit 1; }; Write-Output "^""Successfully enabled the feature `"^""$featureName`"^""."^""; Exit 0"
:: Revert the 'Internet-Explorer-Optional-amd64' feature to its default settings
PowerShell -ExecutionPolicy Unrestricted -Command "$featureName = 'Internet-Explorer-Optional-amd64'; $ignoreMissingOnRevert = $true <# $false #>; $disabledByDefault =  $false; $feature = Get-WindowsOptionalFeature -FeatureName "^""$featureName"^"" -Online -ErrorAction Stop; if (-Not $feature) { if ($ignoreMissingOnRevert) { Write-Output "^""Skipping: The feature `"^""$featureName`"^"" is not found. No action required."^""; Exit 0; }; Write-Error "^""Failed to revert changes to the feature `"^""$featureName`"^"". The feature is not found."^""; Exit 1; }; if ($feature.State -eq [Microsoft.Dism.Commands.FeatureState]::Enabled) { Write-Output "^""Skipping: The feature `"^""$featureName`"^"" is already enabled. No action required."^""; Exit 0; }; if ($disabledByDefault) { Write-Output "^""Skipping: The feature `"^""$featureName`"^"" is already disabled and this is the default configuration."^""; Exit 0; }; try { Write-Host "^""Enabling feature: `"^""$featureName`"^""."^""; Enable-WindowsOptionalFeature -FeatureName "^""$featureName"^"" -Online -NoRestart -LogLevel ([Microsoft.Dism.Commands.LogLevel]::Errors) -WarningAction SilentlyContinue -ErrorAction Stop | Out-Null; } catch { Write-Error "^""Failed to enable feature `"^""$featureName`"^"": $($_.Exception.Message)"^""; Exit 1; }; Write-Output "^""Successfully enabled the feature `"^""$featureName`"^""."^""; Exit 0"
:: ----------------------------------------------------------


:: ----------------------------------------------------------
:: -------Disable "Legacy Components" feature (revert)-------
:: ----------------------------------------------------------
echo --- Disable "Legacy Components" feature (revert)
:: Revert the 'LegacyComponents' feature to its default settings
PowerShell -ExecutionPolicy Unrestricted -Command "$featureName = 'LegacyComponents'; $ignoreMissingOnRevert =  $false; $disabledByDefault = $true <# $false #>; $feature = Get-WindowsOptionalFeature -FeatureName "^""$featureName"^"" -Online -ErrorAction Stop; if (-Not $feature) { if ($ignoreMissingOnRevert) { Write-Output "^""Skipping: The feature `"^""$featureName`"^"" is not found. No action required."^""; Exit 0; }; Write-Error "^""Failed to revert changes to the feature `"^""$featureName`"^"". The feature is not found."^""; Exit 1; }; if ($feature.State -eq [Microsoft.Dism.Commands.FeatureState]::Enabled) { Write-Output "^""Skipping: The feature `"^""$featureName`"^"" is already enabled. No action required."^""; Exit 0; }; if ($disabledByDefault) { Write-Output "^""Skipping: The feature `"^""$featureName`"^"" is already disabled and this is the default configuration."^""; Exit 0; }; try { Write-Host "^""Enabling feature: `"^""$featureName`"^""."^""; Enable-WindowsOptionalFeature -FeatureName "^""$featureName"^"" -Online -NoRestart -LogLevel ([Microsoft.Dism.Commands.LogLevel]::Errors) -WarningAction SilentlyContinue -ErrorAction Stop | Out-Null; } catch { Write-Error "^""Failed to enable feature `"^""$featureName`"^"": $($_.Exception.Message)"^""; Exit 1; }; Write-Output "^""Successfully enabled the feature `"^""$featureName`"^""."^""; Exit 0"
:: ----------------------------------------------------------


:: ----------------------------------------------------------
:: --------Disable "Media Features" feature (revert)---------
:: ----------------------------------------------------------
echo --- Disable "Media Features" feature (revert)
:: Revert the 'MediaPlayback' feature to its default settings
PowerShell -ExecutionPolicy Unrestricted -Command "$featureName = 'MediaPlayback'; $ignoreMissingOnRevert =  $false; $disabledByDefault =  $false; $feature = Get-WindowsOptionalFeature -FeatureName "^""$featureName"^"" -Online -ErrorAction Stop; if (-Not $feature) { if ($ignoreMissingOnRevert) { Write-Output "^""Skipping: The feature `"^""$featureName`"^"" is not found. No action required."^""; Exit 0; }; Write-Error "^""Failed to revert changes to the feature `"^""$featureName`"^"". The feature is not found."^""; Exit 1; }; if ($feature.State -eq [Microsoft.Dism.Commands.FeatureState]::Enabled) { Write-Output "^""Skipping: The feature `"^""$featureName`"^"" is already enabled. No action required."^""; Exit 0; }; if ($disabledByDefault) { Write-Output "^""Skipping: The feature `"^""$featureName`"^"" is already disabled and this is the default configuration."^""; Exit 0; }; try { Write-Host "^""Enabling feature: `"^""$featureName`"^""."^""; Enable-WindowsOptionalFeature -FeatureName "^""$featureName"^"" -Online -NoRestart -LogLevel ([Microsoft.Dism.Commands.LogLevel]::Errors) -WarningAction SilentlyContinue -ErrorAction Stop | Out-Null; } catch { Write-Error "^""Failed to enable feature `"^""$featureName`"^"": $($_.Exception.Message)"^""; Exit 1; }; Write-Output "^""Successfully enabled the feature `"^""$featureName`"^""."^""; Exit 0"
:: ----------------------------------------------------------


:: ----------------------------------------------------------
:: --------Disable "Scan Management" feature (revert)--------
:: ----------------------------------------------------------
echo --- Disable "Scan Management" feature (revert)
:: Revert the 'ScanManagementConsole' feature to its default settings
PowerShell -ExecutionPolicy Unrestricted -Command "$featureName = 'ScanManagementConsole'; $ignoreMissingOnRevert = $true <# $false #>; $disabledByDefault =  $false; $feature = Get-WindowsOptionalFeature -FeatureName "^""$featureName"^"" -Online -ErrorAction Stop; if (-Not $feature) { if ($ignoreMissingOnRevert) { Write-Output "^""Skipping: The feature `"^""$featureName`"^"" is not found. No action required."^""; Exit 0; }; Write-Error "^""Failed to revert changes to the feature `"^""$featureName`"^"". The feature is not found."^""; Exit 1; }; if ($feature.State -eq [Microsoft.Dism.Commands.FeatureState]::Enabled) { Write-Output "^""Skipping: The feature `"^""$featureName`"^"" is already enabled. No action required."^""; Exit 0; }; if ($disabledByDefault) { Write-Output "^""Skipping: The feature `"^""$featureName`"^"" is already disabled and this is the default configuration."^""; Exit 0; }; try { Write-Host "^""Enabling feature: `"^""$featureName`"^""."^""; Enable-WindowsOptionalFeature -FeatureName "^""$featureName"^"" -Online -NoRestart -LogLevel ([Microsoft.Dism.Commands.LogLevel]::Errors) -WarningAction SilentlyContinue -ErrorAction Stop | Out-Null; } catch { Write-Error "^""Failed to enable feature `"^""$featureName`"^"": $($_.Exception.Message)"^""; Exit 1; }; Write-Output "^""Successfully enabled the feature `"^""$featureName`"^""."^""; Exit 0"
:: ----------------------------------------------------------


:: ----------------------------------------------------------
:: -----Disable "Windows Fax and Scan" feature (revert)------
:: ----------------------------------------------------------
echo --- Disable "Windows Fax and Scan" feature (revert)
:: Revert the 'FaxServicesClientPackage' feature to its default settings
PowerShell -ExecutionPolicy Unrestricted -Command "$featureName = 'FaxServicesClientPackage'; $ignoreMissingOnRevert = $true <# $false #>; $disabledByDefault =  $false; $feature = Get-WindowsOptionalFeature -FeatureName "^""$featureName"^"" -Online -ErrorAction Stop; if (-Not $feature) { if ($ignoreMissingOnRevert) { Write-Output "^""Skipping: The feature `"^""$featureName`"^"" is not found. No action required."^""; Exit 0; }; Write-Error "^""Failed to revert changes to the feature `"^""$featureName`"^"". The feature is not found."^""; Exit 1; }; if ($feature.State -eq [Microsoft.Dism.Commands.FeatureState]::Enabled) { Write-Output "^""Skipping: The feature `"^""$featureName`"^"" is already enabled. No action required."^""; Exit 0; }; if ($disabledByDefault) { Write-Output "^""Skipping: The feature `"^""$featureName`"^"" is already disabled and this is the default configuration."^""; Exit 0; }; try { Write-Host "^""Enabling feature: `"^""$featureName`"^""."^""; Enable-WindowsOptionalFeature -FeatureName "^""$featureName"^"" -Online -NoRestart -LogLevel ([Microsoft.Dism.Commands.LogLevel]::Errors) -WarningAction SilentlyContinue -ErrorAction Stop | Out-Null; } catch { Write-Error "^""Failed to enable feature `"^""$featureName`"^"": $($_.Exception.Message)"^""; Exit 1; }; Write-Output "^""Successfully enabled the feature `"^""$featureName`"^""."^""; Exit 0"
:: ----------------------------------------------------------


:: ----------------------------------------------------------
:: -----Disable "Windows Media Player" feature (revert)------
:: ----------------------------------------------------------
echo --- Disable "Windows Media Player" feature (revert)
:: Revert the 'WindowsMediaPlayer' feature to its default settings
PowerShell -ExecutionPolicy Unrestricted -Command "$featureName = 'WindowsMediaPlayer'; $ignoreMissingOnRevert =  $false; $disabledByDefault =  $false; $feature = Get-WindowsOptionalFeature -FeatureName "^""$featureName"^"" -Online -ErrorAction Stop; if (-Not $feature) { if ($ignoreMissingOnRevert) { Write-Output "^""Skipping: The feature `"^""$featureName`"^"" is not found. No action required."^""; Exit 0; }; Write-Error "^""Failed to revert changes to the feature `"^""$featureName`"^"". The feature is not found."^""; Exit 1; }; if ($feature.State -eq [Microsoft.Dism.Commands.FeatureState]::Enabled) { Write-Output "^""Skipping: The feature `"^""$featureName`"^"" is already enabled. No action required."^""; Exit 0; }; if ($disabledByDefault) { Write-Output "^""Skipping: The feature `"^""$featureName`"^"" is already disabled and this is the default configuration."^""; Exit 0; }; try { Write-Host "^""Enabling feature: `"^""$featureName`"^""."^""; Enable-WindowsOptionalFeature -FeatureName "^""$featureName"^"" -Online -NoRestart -LogLevel ([Microsoft.Dism.Commands.LogLevel]::Errors) -WarningAction SilentlyContinue -ErrorAction Stop | Out-Null; } catch { Write-Error "^""Failed to enable feature `"^""$featureName`"^"": $($_.Exception.Message)"^""; Exit 1; }; Write-Output "^""Successfully enabled the feature `"^""$featureName`"^""."^""; Exit 0"
:: ----------------------------------------------------------


:: ----------------------------------------------------------
:: --------Disable "Windows Search" feature (revert)---------
:: ----------------------------------------------------------
echo --- Disable "Windows Search" feature (revert)
:: Revert the 'SearchEngine-Client-Package' feature to its default settings
PowerShell -ExecutionPolicy Unrestricted -Command "$featureName = 'SearchEngine-Client-Package'; $ignoreMissingOnRevert =  $false; $disabledByDefault =  $false; $feature = Get-WindowsOptionalFeature -FeatureName "^""$featureName"^"" -Online -ErrorAction Stop; if (-Not $feature) { if ($ignoreMissingOnRevert) { Write-Output "^""Skipping: The feature `"^""$featureName`"^"" is not found. No action required."^""; Exit 0; }; Write-Error "^""Failed to revert changes to the feature `"^""$featureName`"^"". The feature is not found."^""; Exit 1; }; if ($feature.State -eq [Microsoft.Dism.Commands.FeatureState]::Enabled) { Write-Output "^""Skipping: The feature `"^""$featureName`"^"" is already enabled. No action required."^""; Exit 0; }; if ($disabledByDefault) { Write-Output "^""Skipping: The feature `"^""$featureName`"^"" is already disabled and this is the default configuration."^""; Exit 0; }; try { Write-Host "^""Enabling feature: `"^""$featureName`"^""."^""; Enable-WindowsOptionalFeature -FeatureName "^""$featureName"^"" -Online -NoRestart -LogLevel ([Microsoft.Dism.Commands.LogLevel]::Errors) -WarningAction SilentlyContinue -ErrorAction Stop | Out-Null; } catch { Write-Error "^""Failed to enable feature `"^""$featureName`"^"": $($_.Exception.Message)"^""; Exit 1; }; Write-Output "^""Successfully enabled the feature `"^""$featureName`"^""."^""; Exit 0"
:: ----------------------------------------------------------


:: ----------------------------------------------------------
:: ------------Disable "Hyper-V" feature (revert)------------
:: ----------------------------------------------------------
echo --- Disable "Hyper-V" feature (revert)
:: Revert the 'Microsoft-Hyper-V-All' feature to its default settings
PowerShell -ExecutionPolicy Unrestricted -Command "$featureName = 'Microsoft-Hyper-V-All'; $ignoreMissingOnRevert =  $false; $disabledByDefault = $true <# $false #>; $feature = Get-WindowsOptionalFeature -FeatureName "^""$featureName"^"" -Online -ErrorAction Stop; if (-Not $feature) { if ($ignoreMissingOnRevert) { Write-Output "^""Skipping: The feature `"^""$featureName`"^"" is not found. No action required."^""; Exit 0; }; Write-Error "^""Failed to revert changes to the feature `"^""$featureName`"^"". The feature is not found."^""; Exit 1; }; if ($feature.State -eq [Microsoft.Dism.Commands.FeatureState]::Enabled) { Write-Output "^""Skipping: The feature `"^""$featureName`"^"" is already enabled. No action required."^""; Exit 0; }; if ($disabledByDefault) { Write-Output "^""Skipping: The feature `"^""$featureName`"^"" is already disabled and this is the default configuration."^""; Exit 0; }; try { Write-Host "^""Enabling feature: `"^""$featureName`"^""."^""; Enable-WindowsOptionalFeature -FeatureName "^""$featureName"^"" -Online -NoRestart -LogLevel ([Microsoft.Dism.Commands.LogLevel]::Errors) -WarningAction SilentlyContinue -ErrorAction Stop | Out-Null; } catch { Write-Error "^""Failed to enable feature `"^""$featureName`"^"": $($_.Exception.Message)"^""; Exit 1; }; Write-Output "^""Successfully enabled the feature `"^""$featureName`"^""."^""; Exit 0"
:: ----------------------------------------------------------


:: ----------------------------------------------------------
:: -Disable "Hyper-V GUI Management Tools" feature (revert)--
:: ----------------------------------------------------------
echo --- Disable "Hyper-V GUI Management Tools" feature (revert)
:: Revert the 'Microsoft-Hyper-V-Management-Clients' feature to its default settings
PowerShell -ExecutionPolicy Unrestricted -Command "$featureName = 'Microsoft-Hyper-V-Management-Clients'; $ignoreMissingOnRevert =  $false; $disabledByDefault = $true <# $false #>; $feature = Get-WindowsOptionalFeature -FeatureName "^""$featureName"^"" -Online -ErrorAction Stop; if (-Not $feature) { if ($ignoreMissingOnRevert) { Write-Output "^""Skipping: The feature `"^""$featureName`"^"" is not found. No action required."^""; Exit 0; }; Write-Error "^""Failed to revert changes to the feature `"^""$featureName`"^"". The feature is not found."^""; Exit 1; }; if ($feature.State -eq [Microsoft.Dism.Commands.FeatureState]::Enabled) { Write-Output "^""Skipping: The feature `"^""$featureName`"^"" is already enabled. No action required."^""; Exit 0; }; if ($disabledByDefault) { Write-Output "^""Skipping: The feature `"^""$featureName`"^"" is already disabled and this is the default configuration."^""; Exit 0; }; try { Write-Host "^""Enabling feature: `"^""$featureName`"^""."^""; Enable-WindowsOptionalFeature -FeatureName "^""$featureName"^"" -Online -NoRestart -LogLevel ([Microsoft.Dism.Commands.LogLevel]::Errors) -WarningAction SilentlyContinue -ErrorAction Stop | Out-Null; } catch { Write-Error "^""Failed to enable feature `"^""$featureName`"^"": $($_.Exception.Message)"^""; Exit 1; }; Write-Output "^""Successfully enabled the feature `"^""$featureName`"^""."^""; Exit 0"
:: ----------------------------------------------------------


:: ----------------------------------------------------------
:: ---Disable "Hyper-V Management Tools" feature (revert)----
:: ----------------------------------------------------------
echo --- Disable "Hyper-V Management Tools" feature (revert)
:: Revert the 'Microsoft-Hyper-V-Tools-All' feature to its default settings
PowerShell -ExecutionPolicy Unrestricted -Command "$featureName = 'Microsoft-Hyper-V-Tools-All'; $ignoreMissingOnRevert =  $false; $disabledByDefault = $true <# $false #>; $feature = Get-WindowsOptionalFeature -FeatureName "^""$featureName"^"" -Online -ErrorAction Stop; if (-Not $feature) { if ($ignoreMissingOnRevert) { Write-Output "^""Skipping: The feature `"^""$featureName`"^"" is not found. No action required."^""; Exit 0; }; Write-Error "^""Failed to revert changes to the feature `"^""$featureName`"^"". The feature is not found."^""; Exit 1; }; if ($feature.State -eq [Microsoft.Dism.Commands.FeatureState]::Enabled) { Write-Output "^""Skipping: The feature `"^""$featureName`"^"" is already enabled. No action required."^""; Exit 0; }; if ($disabledByDefault) { Write-Output "^""Skipping: The feature `"^""$featureName`"^"" is already disabled and this is the default configuration."^""; Exit 0; }; try { Write-Host "^""Enabling feature: `"^""$featureName`"^""."^""; Enable-WindowsOptionalFeature -FeatureName "^""$featureName"^"" -Online -NoRestart -LogLevel ([Microsoft.Dism.Commands.LogLevel]::Errors) -WarningAction SilentlyContinue -ErrorAction Stop | Out-Null; } catch { Write-Error "^""Failed to enable feature `"^""$featureName`"^"": $($_.Exception.Message)"^""; Exit 1; }; Write-Output "^""Successfully enabled the feature `"^""$featureName`"^""."^""; Exit 0"
:: ----------------------------------------------------------


:: Disable "Hyper-V Module for Windows PowerShell" feature (revert)
echo --- Disable "Hyper-V Module for Windows PowerShell" feature (revert)
:: Revert the 'Microsoft-Hyper-V-Management-PowerShell' feature to its default settings
PowerShell -ExecutionPolicy Unrestricted -Command "$featureName = 'Microsoft-Hyper-V-Management-PowerShell'; $ignoreMissingOnRevert =  $false; $disabledByDefault = $true <# $false #>; $feature = Get-WindowsOptionalFeature -FeatureName "^""$featureName"^"" -Online -ErrorAction Stop; if (-Not $feature) { if ($ignoreMissingOnRevert) { Write-Output "^""Skipping: The feature `"^""$featureName`"^"" is not found. No action required."^""; Exit 0; }; Write-Error "^""Failed to revert changes to the feature `"^""$featureName`"^"". The feature is not found."^""; Exit 1; }; if ($feature.State -eq [Microsoft.Dism.Commands.FeatureState]::Enabled) { Write-Output "^""Skipping: The feature `"^""$featureName`"^"" is already enabled. No action required."^""; Exit 0; }; if ($disabledByDefault) { Write-Output "^""Skipping: The feature `"^""$featureName`"^"" is already disabled and this is the default configuration."^""; Exit 0; }; try { Write-Host "^""Enabling feature: `"^""$featureName`"^""."^""; Enable-WindowsOptionalFeature -FeatureName "^""$featureName"^"" -Online -NoRestart -LogLevel ([Microsoft.Dism.Commands.LogLevel]::Errors) -WarningAction SilentlyContinue -ErrorAction Stop | Out-Null; } catch { Write-Error "^""Failed to enable feature `"^""$featureName`"^"": $($_.Exception.Message)"^""; Exit 1; }; Write-Output "^""Successfully enabled the feature `"^""$featureName`"^""."^""; Exit 0"
:: ----------------------------------------------------------


:: ----------------------------------------------------------
:: --Disable "Print and Document Services" feature (revert)--
:: ----------------------------------------------------------
echo --- Disable "Print and Document Services" feature (revert)
:: Revert the 'Printing-Foundation-Features' feature to its default settings
PowerShell -ExecutionPolicy Unrestricted -Command "$featureName = 'Printing-Foundation-Features'; $ignoreMissingOnRevert =  $false; $disabledByDefault =  $false; $feature = Get-WindowsOptionalFeature -FeatureName "^""$featureName"^"" -Online -ErrorAction Stop; if (-Not $feature) { if ($ignoreMissingOnRevert) { Write-Output "^""Skipping: The feature `"^""$featureName`"^"" is not found. No action required."^""; Exit 0; }; Write-Error "^""Failed to revert changes to the feature `"^""$featureName`"^"". The feature is not found."^""; Exit 1; }; if ($feature.State -eq [Microsoft.Dism.Commands.FeatureState]::Enabled) { Write-Output "^""Skipping: The feature `"^""$featureName`"^"" is already enabled. No action required."^""; Exit 0; }; if ($disabledByDefault) { Write-Output "^""Skipping: The feature `"^""$featureName`"^"" is already disabled and this is the default configuration."^""; Exit 0; }; try { Write-Host "^""Enabling feature: `"^""$featureName`"^""."^""; Enable-WindowsOptionalFeature -FeatureName "^""$featureName"^"" -Online -NoRestart -LogLevel ([Microsoft.Dism.Commands.LogLevel]::Errors) -WarningAction SilentlyContinue -ErrorAction Stop | Out-Null; } catch { Write-Error "^""Failed to enable feature `"^""$featureName`"^"": $($_.Exception.Message)"^""; Exit 1; }; Write-Output "^""Successfully enabled the feature `"^""$featureName`"^""."^""; Exit 0"
:: ----------------------------------------------------------


:: ----------------------------------------------------------
:: ------Disable "Work Folders Client" feature (revert)------
:: ----------------------------------------------------------
echo --- Disable "Work Folders Client" feature (revert)
:: Revert the 'WorkFolders-Client' feature to its default settings
PowerShell -ExecutionPolicy Unrestricted -Command "$featureName = 'WorkFolders-Client'; $ignoreMissingOnRevert =  $false; $disabledByDefault =  $false; $feature = Get-WindowsOptionalFeature -FeatureName "^""$featureName"^"" -Online -ErrorAction Stop; if (-Not $feature) { if ($ignoreMissingOnRevert) { Write-Output "^""Skipping: The feature `"^""$featureName`"^"" is not found. No action required."^""; Exit 0; }; Write-Error "^""Failed to revert changes to the feature `"^""$featureName`"^"". The feature is not found."^""; Exit 1; }; if ($feature.State -eq [Microsoft.Dism.Commands.FeatureState]::Enabled) { Write-Output "^""Skipping: The feature `"^""$featureName`"^"" is already enabled. No action required."^""; Exit 0; }; if ($disabledByDefault) { Write-Output "^""Skipping: The feature `"^""$featureName`"^"" is already disabled and this is the default configuration."^""; Exit 0; }; try { Write-Host "^""Enabling feature: `"^""$featureName`"^""."^""; Enable-WindowsOptionalFeature -FeatureName "^""$featureName"^"" -Online -NoRestart -LogLevel ([Microsoft.Dism.Commands.LogLevel]::Errors) -WarningAction SilentlyContinue -ErrorAction Stop | Out-Null; } catch { Write-Error "^""Failed to enable feature `"^""$featureName`"^"": $($_.Exception.Message)"^""; Exit 1; }; Write-Output "^""Successfully enabled the feature `"^""$featureName`"^""."^""; Exit 0"
:: ----------------------------------------------------------


:: ----------------------------------------------------------
:: ---Disable "Internet Printing Client" feature (revert)----
:: ----------------------------------------------------------
echo --- Disable "Internet Printing Client" feature (revert)
:: Revert the 'Printing-Foundation-InternetPrinting-Client' feature to its default settings
PowerShell -ExecutionPolicy Unrestricted -Command "$featureName = 'Printing-Foundation-InternetPrinting-Client'; $ignoreMissingOnRevert =  $false; $disabledByDefault =  $false; $feature = Get-WindowsOptionalFeature -FeatureName "^""$featureName"^"" -Online -ErrorAction Stop; if (-Not $feature) { if ($ignoreMissingOnRevert) { Write-Output "^""Skipping: The feature `"^""$featureName`"^"" is not found. No action required."^""; Exit 0; }; Write-Error "^""Failed to revert changes to the feature `"^""$featureName`"^"". The feature is not found."^""; Exit 1; }; if ($feature.State -eq [Microsoft.Dism.Commands.FeatureState]::Enabled) { Write-Output "^""Skipping: The feature `"^""$featureName`"^"" is already enabled. No action required."^""; Exit 0; }; if ($disabledByDefault) { Write-Output "^""Skipping: The feature `"^""$featureName`"^"" is already disabled and this is the default configuration."^""; Exit 0; }; try { Write-Host "^""Enabling feature: `"^""$featureName`"^""."^""; Enable-WindowsOptionalFeature -FeatureName "^""$featureName"^"" -Online -NoRestart -LogLevel ([Microsoft.Dism.Commands.LogLevel]::Errors) -WarningAction SilentlyContinue -ErrorAction Stop | Out-Null; } catch { Write-Error "^""Failed to enable feature `"^""$featureName`"^"": $($_.Exception.Message)"^""; Exit 1; }; Write-Output "^""Successfully enabled the feature `"^""$featureName`"^""."^""; Exit 0"
:: ----------------------------------------------------------


:: ----------------------------------------------------------
:: -------Disable "LPD Print Service" feature (revert)-------
:: ----------------------------------------------------------
echo --- Disable "LPD Print Service" feature (revert)
:: Revert the 'Printing-Foundation-LPDPrintService' feature to its default settings
PowerShell -ExecutionPolicy Unrestricted -Command "$featureName = 'Printing-Foundation-LPDPrintService'; $ignoreMissingOnRevert =  $false; $disabledByDefault = $true <# $false #>; $feature = Get-WindowsOptionalFeature -FeatureName "^""$featureName"^"" -Online -ErrorAction Stop; if (-Not $feature) { if ($ignoreMissingOnRevert) { Write-Output "^""Skipping: The feature `"^""$featureName`"^"" is not found. No action required."^""; Exit 0; }; Write-Error "^""Failed to revert changes to the feature `"^""$featureName`"^"". The feature is not found."^""; Exit 1; }; if ($feature.State -eq [Microsoft.Dism.Commands.FeatureState]::Enabled) { Write-Output "^""Skipping: The feature `"^""$featureName`"^"" is already enabled. No action required."^""; Exit 0; }; if ($disabledByDefault) { Write-Output "^""Skipping: The feature `"^""$featureName`"^"" is already disabled and this is the default configuration."^""; Exit 0; }; try { Write-Host "^""Enabling feature: `"^""$featureName`"^""."^""; Enable-WindowsOptionalFeature -FeatureName "^""$featureName"^"" -Online -NoRestart -LogLevel ([Microsoft.Dism.Commands.LogLevel]::Errors) -WarningAction SilentlyContinue -ErrorAction Stop | Out-Null; } catch { Write-Error "^""Failed to enable feature `"^""$featureName`"^"": $($_.Exception.Message)"^""; Exit 1; }; Write-Output "^""Successfully enabled the feature `"^""$featureName`"^""."^""; Exit 0"
:: ----------------------------------------------------------


:: ----------------------------------------------------------
:: -------Disable "LPR Port Monitor" feature (revert)--------
:: ----------------------------------------------------------
echo --- Disable "LPR Port Monitor" feature (revert)
:: Revert the 'Printing-Foundation-LPRPortMonitor' feature to its default settings
PowerShell -ExecutionPolicy Unrestricted -Command "$featureName = 'Printing-Foundation-LPRPortMonitor'; $ignoreMissingOnRevert =  $false; $disabledByDefault = $true <# $false #>; $feature = Get-WindowsOptionalFeature -FeatureName "^""$featureName"^"" -Online -ErrorAction Stop; if (-Not $feature) { if ($ignoreMissingOnRevert) { Write-Output "^""Skipping: The feature `"^""$featureName`"^"" is not found. No action required."^""; Exit 0; }; Write-Error "^""Failed to revert changes to the feature `"^""$featureName`"^"". The feature is not found."^""; Exit 1; }; if ($feature.State -eq [Microsoft.Dism.Commands.FeatureState]::Enabled) { Write-Output "^""Skipping: The feature `"^""$featureName`"^"" is already enabled. No action required."^""; Exit 0; }; if ($disabledByDefault) { Write-Output "^""Skipping: The feature `"^""$featureName`"^"" is already disabled and this is the default configuration."^""; Exit 0; }; try { Write-Host "^""Enabling feature: `"^""$featureName`"^""."^""; Enable-WindowsOptionalFeature -FeatureName "^""$featureName"^"" -Online -NoRestart -LogLevel ([Microsoft.Dism.Commands.LogLevel]::Errors) -WarningAction SilentlyContinue -ErrorAction Stop | Out-Null; } catch { Write-Error "^""Failed to enable feature `"^""$featureName`"^"": $($_.Exception.Message)"^""; Exit 1; }; Write-Output "^""Successfully enabled the feature `"^""$featureName`"^""."^""; Exit 0"
:: ----------------------------------------------------------


:: ----------------------------------------------------------
:: ----Disable "Microsoft Print to PDF" feature (revert)-----
:: ----------------------------------------------------------
echo --- Disable "Microsoft Print to PDF" feature (revert)
:: Revert the 'Printing-PrintToPDFServices-Features' feature to its default settings
PowerShell -ExecutionPolicy Unrestricted -Command "$featureName = 'Printing-PrintToPDFServices-Features'; $ignoreMissingOnRevert =  $false; $disabledByDefault =  $false; $feature = Get-WindowsOptionalFeature -FeatureName "^""$featureName"^"" -Online -ErrorAction Stop; if (-Not $feature) { if ($ignoreMissingOnRevert) { Write-Output "^""Skipping: The feature `"^""$featureName`"^"" is not found. No action required."^""; Exit 0; }; Write-Error "^""Failed to revert changes to the feature `"^""$featureName`"^"". The feature is not found."^""; Exit 1; }; if ($feature.State -eq [Microsoft.Dism.Commands.FeatureState]::Enabled) { Write-Output "^""Skipping: The feature `"^""$featureName`"^"" is already enabled. No action required."^""; Exit 0; }; if ($disabledByDefault) { Write-Output "^""Skipping: The feature `"^""$featureName`"^"" is already disabled and this is the default configuration."^""; Exit 0; }; try { Write-Host "^""Enabling feature: `"^""$featureName`"^""."^""; Enable-WindowsOptionalFeature -FeatureName "^""$featureName"^"" -Online -NoRestart -LogLevel ([Microsoft.Dism.Commands.LogLevel]::Errors) -WarningAction SilentlyContinue -ErrorAction Stop | Out-Null; } catch { Write-Error "^""Failed to enable feature `"^""$featureName`"^"": $($_.Exception.Message)"^""; Exit 1; }; Write-Output "^""Successfully enabled the feature `"^""$featureName`"^""."^""; Exit 0"
:: ----------------------------------------------------------


:: ----------------------------------------------------------
:: -Disable "Microsoft XPS Document Writer" feature (revert)-
:: ----------------------------------------------------------
echo --- Disable "Microsoft XPS Document Writer" feature (revert)
:: Revert the 'Printing-XPSServices-Features' feature to its default settings
PowerShell -ExecutionPolicy Unrestricted -Command "$featureName = 'Printing-XPSServices-Features'; $ignoreMissingOnRevert =  $false; $disabledByDefault = $true <# $false #>; $feature = Get-WindowsOptionalFeature -FeatureName "^""$featureName"^"" -Online -ErrorAction Stop; if (-Not $feature) { if ($ignoreMissingOnRevert) { Write-Output "^""Skipping: The feature `"^""$featureName`"^"" is not found. No action required."^""; Exit 0; }; Write-Error "^""Failed to revert changes to the feature `"^""$featureName`"^"". The feature is not found."^""; Exit 1; }; if ($feature.State -eq [Microsoft.Dism.Commands.FeatureState]::Enabled) { Write-Output "^""Skipping: The feature `"^""$featureName`"^"" is already enabled. No action required."^""; Exit 0; }; if ($disabledByDefault) { Write-Output "^""Skipping: The feature `"^""$featureName`"^"" is already disabled and this is the default configuration."^""; Exit 0; }; try { Write-Host "^""Enabling feature: `"^""$featureName`"^""."^""; Enable-WindowsOptionalFeature -FeatureName "^""$featureName"^"" -Online -NoRestart -LogLevel ([Microsoft.Dism.Commands.LogLevel]::Errors) -WarningAction SilentlyContinue -ErrorAction Stop | Out-Null; } catch { Write-Error "^""Failed to enable feature `"^""$featureName`"^"": $($_.Exception.Message)"^""; Exit 1; }; Write-Output "^""Successfully enabled the feature `"^""$featureName`"^""."^""; Exit 0"
:: ----------------------------------------------------------


:: ----------------------------------------------------------
:: ----------Disable "XPS Viewer" feature (revert)-----------
:: ----------------------------------------------------------
echo --- Disable "XPS Viewer" feature (revert)
:: Revert the 'Xps-Foundation-Xps-Viewer' feature to its default settings
PowerShell -ExecutionPolicy Unrestricted -Command "$featureName = 'Xps-Foundation-Xps-Viewer'; $ignoreMissingOnRevert = $true <# $false #>; $disabledByDefault =  $false; $feature = Get-WindowsOptionalFeature -FeatureName "^""$featureName"^"" -Online -ErrorAction Stop; if (-Not $feature) { if ($ignoreMissingOnRevert) { Write-Output "^""Skipping: The feature `"^""$featureName`"^"" is not found. No action required."^""; Exit 0; }; Write-Error "^""Failed to revert changes to the feature `"^""$featureName`"^"". The feature is not found."^""; Exit 1; }; if ($feature.State -eq [Microsoft.Dism.Commands.FeatureState]::Enabled) { Write-Output "^""Skipping: The feature `"^""$featureName`"^"" is already enabled. No action required."^""; Exit 0; }; if ($disabledByDefault) { Write-Output "^""Skipping: The feature `"^""$featureName`"^"" is already disabled and this is the default configuration."^""; Exit 0; }; try { Write-Host "^""Enabling feature: `"^""$featureName`"^""."^""; Enable-WindowsOptionalFeature -FeatureName "^""$featureName"^"" -Online -NoRestart -LogLevel ([Microsoft.Dism.Commands.LogLevel]::Errors) -WarningAction SilentlyContinue -ErrorAction Stop | Out-Null; } catch { Write-Error "^""Failed to enable feature `"^""$featureName`"^"": $($_.Exception.Message)"^""; Exit 1; }; Write-Output "^""Successfully enabled the feature `"^""$featureName`"^""."^""; Exit 0"
:: ----------------------------------------------------------


:: Pause the script to view the final state
pause
:: Restore previous environment settings
endlocal
:: Exit the script successfully
exit /b 0